Scriptname RF:TutorialQuest Extends Quest

RF:FuelHandlerQuest Property RFQ Auto Mandatory Const

; The Tutorial messages are one-time-only on mod startup
Message Property _RF_tutorial_outoffuel Mandatory Const Auto
Message Property _RF_tutorial_lowfuel Mandatory Const Auto
Message Property _RF_tutorial_stranded Mandatory Const Auto
Message Property _RF_tutorial_heliumexplosion Mandatory Const Auto
Message Property _RF_tutorial_cooldown Mandatory Const Auto

Message[] Property NagMessages Mandatory Const Auto
{ 0: Grav Jump Disabled, 1: Grav Jump Disabled Map, }

Quest Property MQ101 Mandatory Const Auto

SpaceshipReference MyShip
Actor PlayerRef

bool ShowTutorialFuel = true ; We are LOW not out of fuel and can refuel by the panel
bool ShowTutorialGrav = true ; We are OUT of fuel and have to repair our ship up to x% and add fuel to grav jump
bool ShowTutorialTrav = true ; We are STRANDED and have to do something special to continue
bool ShowTutorialExplo = true ; we got HIT with TOO MUCH HE-3 in the cargo hold and blew up
bool ShowTutorialCD = true

Int[] Property TutorialCounters Auto
{ This has to correspond to a message array and will be used in a smart looping notify function for nags }

; 0: Grav Jump Disabled, 1: Grav Jump Disabled Map,
Function Nag(int aiTheMessage = 0, int aiDur = 7)
    int Count = TutorialCounters[aiTheMessage]
    bool Show = False
    If Count == 0 || Count >= 4
        Show = True
    Else ; If Count > 0 && Count < 4
        RFQ.QuickTrace("Tutorial: Nag Skipping " + aiTheMessage + " for " + Count)
        TutorialCounters[aiTheMessage] += 1
    EndIF
    If Show
        NagMessages[aiTheMessage].ShowAsHelpMessage(asEvent = 1, afDuration = aiDur, afInterval = 1, aiMaxTimes = 1)
        TutorialCounters[aiTheMessage] = 1
    EndIF
EndFunction

; There are only a few so we can do this manually
; Now returns whether something was shown so we can skip secondary notifs
;    1: LOW 2: OUT 3: STRANDED 4: YOUR SHIT BLEW UP
bool Function ShowTutorial(int aiTheMessage = 0)
    bool Shown = false
    If aiTheMessage == 0
        ;Do nothing, called empty
    ElseIf aiTheMessage == 1
        If ShowTutorialFuel
            _RF_tutorial_lowfuel.Show()
            ShowTutorialFuel = false
            Shown = true
            Utility.Wait(5)
        EndIf
    ElseIf aiTheMessage == 2
        If ShowTutorialGrav
            _RF_tutorial_outoffuel.Show()
            ShowTutorialGrav = false
            Shown = true
            Utility.Wait(5)
        EndIF
    ElseIF aiTheMessage == 3
        If ShowTutorialTrav
            _RF_tutorial_stranded.Show()
            ShowTutorialTrav = false
            Shown = true
            Utility.Wait(5)
        EndIF
    ElseIF aiTheMessage == 4
        If ShowTutorialExplo
            _RF_tutorial_heliumexplosion.Show()
            ShowTutorialExplo = false
            Shown = true
            Utility.Wait(5)
        EndIF
    ElseIF aiTheMessage == 5
        If ShowTutorialExplo
            _RF_tutorial_cooldown.Show()
            ShowTutorialCD = false
            Shown = true
            Utility.Wait(5)
        EndIF
    EndIf
    Return Shown
EndFunction

;This is just for any banner message
Function HelpMessage(Message asMessageToShow, int Duration = 7, bool abWait = false)
    If abWait
        Utility.Wait(2)
    EndIf
    If asMessageToShow
        asMessageToShow.ShowAsHelpMessage(asEvent = 1, afDuration = Duration, afInterval = 1, aiMaxTimes = 1)
    EndIF
EndFunction

Event OnQuestInit()
    StartTimer(3)
EndEvent

Event OnTimer(int aiTimerID)
    PlayerREf = Game.GetPlayer()
    RegisterForRemoteEvent(MQ101, "OnStageSet")
    Debug.Trace("RF Tutorial system started")
EndEvent

Event Quest.OnStageSet(Quest akSender, int auiStageID, int auiItemID)
    if akSender == MQ101
        If auiStageID == 500 ; Fleet encounter over
            Debug.Trace("RF Tutorial detected " + auiStageID + " and is refueling + adding canisters")
            MyShip = RFQ.GetShip()
            RFQ.GetFuelLevel()
            ;MyShip.AddItem(RFQ.FuelTanks[0], 4, true)
            RFQ.Realfuel(true)
        ElseIf auiStageID == 605 ; Got to Kreet
            Debug.Trace("RF Tutorial detected " + auiStageID + " (Kreet) and is refueling again for safety ")
            RFQ.Realfuel(true)
        ElseIf auiStageID == 1300 ; Got to Kreet
            Utility.Wait(2)
            Debug.Trace("RF Tutorial detected " + auiStageID + " (Jemison) and is refueling again for safety ")
            RFQ.Realfuel(true)
        ElseIf auiStageID == 1800 || auiStageID == 2100 ; Quest complete
            UnRegisterForRemoteEvent(MQ101, "OnStageSet")
        EndIf
    EndIF
EndEvent
